<!DOCTYPE html>
<html lang="es">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Fresil C.A. — Dashboard</title>
<link href="https://fonts.googleapis.com/css2?family=Barlow+Condensed:wght@700;800;900&family=Barlow:wght@400;500;600&display=swap" rel="stylesheet">
<style>
  :root {
    --red:#D42B2F; --green:#2A8A3E; --gray-900:#141414; --gray-800:#1c1c1c;
    --gray-700:#2a2a2a; --gray-400:#888; --gray-100:#e8e8e8; --white:#fff;
  }
  *{margin:0;padding:0;box-sizing:border-box;}
  body{background:var(--gray-900);color:var(--gray-100);font-family:'Barlow',sans-serif;min-height:100vh;}

  /* TOPBAR */
  .topbar{
    background:var(--gray-800);border-bottom:1px solid rgba(255,255,255,0.06);
    padding:0 24px;height:60px;display:flex;align-items:center;justify-content:space-between;
    position:sticky;top:0;z-index:100;
  }
  .topbar-brand{
    font-family:'Barlow Condensed',sans-serif;font-size:22px;font-weight:800;
    display:flex;align-items:center;gap:12px;
  }
  .topbar-brand .brand-dot{
    width:10px;height:10px;border-radius:50%;background:var(--red);
    box-shadow:0 0 8px rgba(212,43,47,0.6);
  }
  .topbar-right{display:flex;align-items:center;gap:16px;}
  .user-chip{
    display:flex;align-items:center;gap:10px;
    background:rgba(255,255,255,0.04);border:1px solid rgba(255,255,255,0.08);
    border-radius:24px;padding:6px 14px;font-size:14px;
  }
  .user-avatar{
    width:28px;height:28px;border-radius:50%;
    background:linear-gradient(135deg,var(--red),var(--red-dark,#a81e21));
    display:flex;align-items:center;justify-content:center;
    font-size:12px;font-weight:700;color:#fff;
    font-family:'Barlow Condensed',sans-serif;
  }
  .btn-logout{
    background:none;border:1px solid rgba(212,43,47,0.4);color:var(--red);
    padding:6px 14px;border-radius:8px;cursor:pointer;font-size:13px;
    font-family:'Barlow',sans-serif;transition:all 0.2s;
  }
  .btn-logout:hover{background:rgba(212,43,47,0.1);}

  /* MAIN */
  .main{padding:32px 24px;max-width:1200px;margin:0 auto;}
  .welcome-banner{
    background:linear-gradient(135deg,rgba(212,43,47,0.12) 0%,rgba(42,138,62,0.08) 100%);
    border:1px solid rgba(255,255,255,0.06);border-radius:16px;
    padding:28px 32px;margin-bottom:32px;
    display:flex;align-items:center;justify-content:space-between;flex-wrap:wrap;gap:16px;
  }
  .welcome-title{font-family:'Barlow Condensed',sans-serif;font-size:26px;font-weight:800;}
  .welcome-title span{color:var(--red);}
  .welcome-sub{color:var(--gray-400);font-size:14px;margin-top:4px;}
  .role-badge{
    padding:5px 14px;border-radius:20px;font-size:12px;font-weight:700;letter-spacing:1px;
    text-transform:uppercase;
  }
  .role-admin  {background:rgba(212,43,47,0.15);color:#ff8a8a;border:1px solid rgba(212,43,47,0.3);}
  .role-almacen{background:rgba(245,158,11,0.15);color:#fbbf24;border:1px solid rgba(245,158,11,0.3);}
  .role-vendedor{background:rgba(42,138,62,0.15);color:#6dd68a;border:1px solid rgba(42,138,62,0.3);}
  .role-solo_lectura{background:rgba(136,136,136,0.15);color:#aaa;border:1px solid rgba(136,136,136,0.3);}

  /* MÓDULOS GRID */
  .modules-title{
    font-family:'Barlow Condensed',sans-serif;font-size:14px;letter-spacing:3px;
    text-transform:uppercase;color:var(--gray-400);margin-bottom:16px;
  }
  .modules-grid{display:grid;grid-template-columns:repeat(auto-fill,minmax(220px,1fr));gap:14px;}
  .module-card{
    background:var(--gray-800);border:1px solid rgba(255,255,255,0.06);
    border-radius:14px;padding:22px;cursor:pointer;transition:all 0.2s;
    text-decoration:none;color:inherit;display:block;
    position:relative;overflow:hidden;
  }
  .module-card::before{
    content:'';position:absolute;top:0;left:0;right:0;height:3px;
    border-radius:14px 14px 0 0;opacity:0;transition:opacity 0.2s;
  }
  .module-card.red::before{background:var(--red);}
  .module-card.green::before{background:var(--green);}
  .module-card:hover{transform:translateY(-2px);border-color:rgba(255,255,255,0.12);}
  .module-card:hover::before{opacity:1;}
  .module-icon{font-size:28px;margin-bottom:12px;}
  .module-name{font-family:'Barlow Condensed',sans-serif;font-size:17px;font-weight:700;margin-bottom:4px;}
  .module-desc{font-size:13px;color:var(--gray-400);}
  .module-status{
    display:inline-block;margin-top:10px;font-size:11px;padding:2px 10px;
    border-radius:10px;font-weight:600;
  }
  .status-active{background:rgba(42,138,62,0.2);color:#6dd68a;}
  .status-coming{background:rgba(136,136,136,0.15);color:#666;}
</style>
</head>
<body>

<div class="topbar">
  <div class="topbar-brand">
    <div class="brand-dot"></div>
    Fresil <span style="color:var(--red)">C.A.</span>
  </div>
  <div class="topbar-right">
    <div class="user-chip">
      <div class="user-avatar" id="userAvatar">F</div>
      <span id="userName">Cargando...</span>
    </div>
    <button class="btn-logout" onclick="logout()">Salir</button>
  </div>
</div>

<div class="main">
  <div class="welcome-banner">
    <div>
      <div class="welcome-title">Bienvenido, <span id="welcomeName">usuario</span></div>
      <div class="welcome-sub" id="welcomeInfo">Sistema de Inventario · Fresil C.A. · Caracas</div>
    </div>
    <div class="role-badge" id="roleBadge">cargando</div>
  </div>

  <div class="modules-title">Módulos del Sistema</div>
  <div class="modules-grid">
    <a href="./usuarios/index.html" class="module-card red" id="cardUsuarios" style="display:none;">
      <div class="module-icon">👥</div>
      <div class="module-name">Usuarios</div>
      <div class="module-desc">Gestión de cuentas y roles</div>
      <span class="module-status status-active">✓ Activo</span>
    </a>
    <div class="module-card green">
      <div class="module-icon">📦</div>
      <div class="module-name">Repuestos</div>
      <div class="module-desc">Catálogo de inventario</div>
      <span class="module-status status-coming">Próximamente</span>
    </div>
    <div class="module-card red">
      <div class="module-icon">👤</div>
      <div class="module-name">Proveedores</div>
      <div class="module-desc">Gestión de proveedores</div>
      <span class="module-status status-coming">Próximamente</span>
    </div>
    <div class="module-card green">
      <div class="module-icon">🛒</div>
      <div class="module-name">Compras</div>
      <div class="module-desc">Órdenes de compra</div>
      <span class="module-status status-coming">Próximamente</span>
    </div>
    <div class="module-card red">
      <div class="module-icon">💰</div>
      <div class="module-name">Ventas</div>
      <div class="module-desc">Despacho y facturación</div>
      <span class="module-status status-coming">Próximamente</span>
    </div>
    <div class="module-card green">
      <div class="module-icon">📊</div>
      <div class="module-name">Reportes</div>
      <div class="module-desc">Dashboard e informes</div>
      <span class="module-status status-coming">Próximamente</span>
    </div>
  </div>
</div>

<script>
'use strict';
const TOKEN_KEY  = 'fresil_token';
const REFRESH_KEY = 'fresil_refresh';

function getToken() {
  return sessionStorage.getItem(TOKEN_KEY) || localStorage.getItem(TOKEN_KEY);
}
function getUser() {
  const raw = sessionStorage.getItem('fresil_user') || localStorage.getItem('fresil_user');
  try { return JSON.parse(raw); } catch { return null; }
}

(function init() {
  const token = getToken();
  if (!token) { window.location.href = './login.html'; return; }

  try {
    const b64     = token.split('.')[1].replace(/-/g,'+').replace(/_/g,'/');
    const payload = JSON.parse(atob(b64));
    if (payload.exp < Math.floor(Date.now()/1000)) {
      window.location.href = './login.html';
      return;
    }
  } catch { window.location.href = './login.html'; return; }

  const user = getUser();
  if (!user) { window.location.href = './login.html'; return; }

  const initial = user.nombre.charAt(0).toUpperCase();
  document.getElementById('userAvatar').textContent  = initial;
  document.getElementById('userName').textContent    = user.nombre;
  document.getElementById('welcomeName').textContent = user.nombre.split(' ')[0];
  document.getElementById('welcomeInfo').textContent =
    `${new Date().toLocaleDateString('es-VE',{weekday:'long',day:'numeric',month:'long',year:'numeric'})} · Fresil C.A.`;

  const badge = document.getElementById('roleBadge');
  const labels = {admin:'Administrador',almacen:'Almacén',vendedor:'Vendedor',solo_lectura:'Solo Lectura'};
  badge.textContent = labels[user.rol] || user.rol;
  badge.className   = `role-badge role-${user.rol}`;

  if (user.rol === 'admin') {
    document.getElementById('cardUsuarios').style.display = 'block';
  }
})();

async function logout() {
  try {
    const token   = getToken();
    const refresh = sessionStorage.getItem(REFRESH_KEY) || localStorage.getItem(REFRESH_KEY);
    await fetch('./api/auth/logout.php', {
      method:'POST',
      headers:{'Content-Type':'application/json','Authorization':'Bearer '+token},
      body: JSON.stringify({refresh_token: refresh || ''})
    });
  } catch(e) {}
  sessionStorage.clear();
  localStorage.removeItem('fresil_token');
  localStorage.removeItem('fresil_refresh');
  localStorage.removeItem('fresil_user');
  window.location.href = './login.html';
}
</script>
</body>
</html>
