<?php
declare(strict_types=1);

/**
 * ============================================================
 * FRESIL C.A. — Sistema de Inventario
 * Configuración Principal de la Aplicación
 * ============================================================
 */

// ── Entorno ──────────────────────────────────────────────────
define('APP_ENV',     getenv('APP_ENV') ?: 'production');   // 'development' | 'production'
define('APP_NAME',    'Fresil C.A. — Inventario');
define('APP_VERSION', '1.0.0');
define('APP_URL',     getenv('APP_URL') ?: 'http://localhost');

// ── Rutas de directorios ──────────────────────────────────────
define('ROOT_PATH',    dirname(__DIR__));
define('CONFIG_PATH',  ROOT_PATH . '/config');
define('CLASSES_PATH', ROOT_PATH . '/classes');
define('ASSETS_PATH',  ROOT_PATH . '/assets');

// ── Seguridad: Claves (CAMBIAR EN PRODUCCIÓN) ─────────────────
// Generar con: php -r "echo bin2hex(random_bytes(32));"
define('JWT_SECRET',          getenv('JWT_SECRET')          ?: 'CAMBIA_ESTA_CLAVE_JWT_MINIMO_256_BITS_32CHARS!!');
define('JWT_EXPIRE_MINUTES',  (int)(getenv('JWT_EXPIRE')    ?: 480));   // 8 horas
define('JWT_REFRESH_DAYS',    (int)(getenv('JWT_REFRESH')   ?: 30));    // 30 días
define('APP_KEY',             getenv('APP_KEY')             ?: 'CAMBIA_ESTA_APP_KEY_PARA_ENCRIPTACION!!');

// ── Sesiones ──────────────────────────────────────────────────
define('SESSION_NAME',        'fresil_session');
define('SESSION_LIFETIME',    60 * 60 * 8);   // 8 horas en segundos

// ── Seguridad: Rate Limiting ──────────────────────────────────
define('LOGIN_MAX_ATTEMPTS',  5);             // Intentos antes de bloqueo
define('LOGIN_LOCKOUT_MINS',  30);            // Minutos de bloqueo
define('RATE_LIMIT_WINDOW',   60);            // Ventana en segundos
define('RATE_LIMIT_MAX_REQ',  60);            // Max requests por ventana

// ── Venezuela: Configuración monetaria ───────────────────────
define('MONEDA_PRINCIPAL',    'USD');
define('MONEDA_LOCAL',        'VES');
define('SIMBOLO_PRINCIPAL',   '$');
define('SIMBOLO_LOCAL',       'Bs.');
define('IVA_PORCENTAJE',      16.00);

// ── Base de datos ─────────────────────────────────────────────
define('DB_HOST',     getenv('DB_HOST')     ?: '127.0.0.1');
define('DB_PORT',     getenv('DB_PORT')     ?: '3306');
define('DB_NAME',     getenv('DB_NAME')     ?: 'fresil_inventario');
define('DB_USER',     getenv('DB_USER')     ?: 'fresil_user');
define('DB_PASS',     getenv('DB_PASS')     ?: '');
define('DB_CHARSET',  'utf8mb4');

// ── Zona horaria ──────────────────────────────────────────────
date_default_timezone_set('America/Caracas');

// ── PHP: Configuración de seguridad ──────────────────────────
if (APP_ENV === 'production') {
    ini_set('display_errors',         '0');
    ini_set('display_startup_errors', '0');
    error_reporting(0);
} else {
    ini_set('display_errors',         '1');
    ini_set('display_startup_errors', '1');
    error_reporting(E_ALL);
}

ini_set('session.cookie_httponly',  '1');
ini_set('session.cookie_secure',    '0');  // Cambiar a '1' con HTTPS
ini_set('session.cookie_samesite',  'Strict');
ini_set('session.use_strict_mode',  '1');
ini_set('session.gc_maxlifetime',   (string)SESSION_LIFETIME);

// ── Headers de seguridad globales ────────────────────────────
header('X-Content-Type-Options: nosniff');
header('X-Frame-Options: DENY');
header('X-XSS-Protection: 1; mode=block');
header('Referrer-Policy: strict-origin-when-cross-origin');
