<?php
declare(strict_types=1);
/**
 * POST /api/usuarios/password.php — Cambiar propia contraseña
 * Cualquier usuario autenticado puede usarlo (no solo admin)
 */
require_once dirname(__DIR__, 2) . '/config/config.php';
require_once CLASSES_PATH . '/Database.php';
require_once CLASSES_PATH . '/JWT.php';
require_once CLASSES_PATH . '/Usuario.php';
require_once ROOT_PATH . '/middleware/AuthMiddleware.php';

header('Content-Type: application/json; charset=utf-8');
if ($_SERVER['REQUEST_METHOD'] !== 'POST') { AuthMiddleware::abort(405, 'Método no permitido.'); }

try {
    $user = AuthMiddleware::requireAuth();
    $body = json_decode(file_get_contents('php://input'), true, flags: JSON_THROW_ON_ERROR);

    $passwordActual = (string)($body['password_actual'] ?? '');
    $passwordNueva  = (string)($body['password_nueva']  ?? '');
    $confirmar      = (string)($body['confirmar']        ?? '');

    if (empty($passwordActual) || empty($passwordNueva)) {
        AuthMiddleware::abort(400, 'Contraseña actual y nueva son requeridas.');
    }
    if ($passwordNueva !== $confirmar) {
        AuthMiddleware::abort(422, 'La nueva contraseña y la confirmación no coinciden.');
    }

    $modelo = new Usuario();
    $modelo->cambiarPassword((int)$user['id'], $passwordActual, $passwordNueva, AuthMiddleware::getClientIp());

    AuthMiddleware::respond(['mensaje' => 'Contraseña actualizada correctamente.']);
} catch (RuntimeException $e) {
    AuthMiddleware::abort($e->getCode() ?: 400, $e->getMessage());
} catch (\Throwable $e) {
    AuthMiddleware::abort(500, 'Error interno del servidor.');
}
