# FRESIL C.A. — Módulo 01: Autenticación y Usuarios
## Guía de Instalación Rápida

---

### 📁 Estructura de Archivos

```
fresil/
├── login.html                  ← Página de inicio de sesión
├── dashboard.php               ← Panel principal post-login
├── .htaccess                   ← Seguridad Apache
├── config/
│   ├── config.php              ← Configuración general (EDITAR)
│   └── 001_auth_schema.sql     ← Script SQL a ejecutar en MySQL
├── classes/
│   ├── Database.php            ← Conexión PDO Singleton
│   ├── JWT.php                 ← Implementación JWT HS256
│   ├── Auth.php                ← Lógica de autenticación
│   └── Usuario.php             ← CRUD de usuarios
├── middleware/
│   └── AuthMiddleware.php      ← Verificación JWT en endpoints
├── api/
│   ├── auth/
│   │   ├── login.php           ← POST: iniciar sesión
│   │   ├── logout.php          ← POST: cerrar sesión
│   │   ├── refresh.php         ← POST: renovar token
│   │   └── me.php              ← GET: usuario actual
│   └── usuarios/
│       ├── index.php           ← CRUD usuarios (admin)
│       └── password.php        ← Cambiar contraseña propia
└── usuarios/
    └── index.html              ← Gestión de usuarios (UI)
```

---

### ⚡ Pasos de Instalación

**1. Subir archivos al servidor**
```
Copiar toda la carpeta fresil/ al directorio raíz del hosting
(ej: /public_html/ o /www/)
```

**2. Crear base de datos y usuario MySQL**
```sql
CREATE DATABASE fresil_inventario CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
CREATE USER 'fresil_user'@'localhost' IDENTIFIED BY 'TU_PASSWORD_AQUI';
GRANT SELECT, INSERT, UPDATE ON fresil_inventario.* TO 'fresil_user'@'localhost';
FLUSH PRIVILEGES;
```

**3. Ejecutar el script SQL**
```bash
mysql -u root -p fresil_inventario < config/001_auth_schema.sql
```

**4. Configurar credenciales en config/config.php**
```php
// Cambiar estas líneas:
define('DB_HOST', '127.0.0.1');           // Host de MySQL
define('DB_NAME', 'fresil_inventario');   // Nombre de la BD
define('DB_USER', 'fresil_user');         // Usuario MySQL
define('DB_PASS', 'TU_PASSWORD_AQUI');    // Contraseña MySQL

// CRÍTICO: Cambiar estas claves por valores únicos generados:
// php -r "echo bin2hex(random_bytes(32));"
define('JWT_SECRET', 'TU_CLAVE_SECRETA_UNICA_DE_256_BITS_AQUI');
define('APP_KEY',    'TU_APP_KEY_UNICA_AQUI');
```

**5. Acceder al sistema**
```
URL: https://tudominio.com/fresil/login.html
Email: admin@fresil.com
Clave: Fresil2024!   ← CAMBIAR INMEDIATAMENTE
```

---

### 🔐 Credenciales Iniciales

| Campo    | Valor                |
|----------|----------------------|
| Email    | admin@fresil.com     |
| Password | Fresil2024!          |
| Rol      | Administrador        |

> ⚠️ **CAMBIAR LA CONTRASEÑA INMEDIATAMENTE** tras el primer acceso.

---

### 🌐 Endpoints de la API

| Método | URL                          | Descripción           | Auth |
|--------|------------------------------|-----------------------|------|
| POST   | /api/auth/login.php          | Iniciar sesión        | No   |
| POST   | /api/auth/logout.php         | Cerrar sesión         | ✓    |
| POST   | /api/auth/refresh.php        | Renovar token         | No   |
| GET    | /api/auth/me.php             | Usuario actual        | ✓    |
| GET    | /api/usuarios/index.php      | Listar usuarios       | Admin|
| POST   | /api/usuarios/index.php      | Crear usuario         | Admin|
| GET    | /api/usuarios/index.php?id=N | Obtener usuario       | Admin|
| PUT    | /api/usuarios/index.php?id=N | Actualizar usuario    | Admin|
| DELETE | /api/usuarios/index.php?id=N | Desactivar usuario    | Admin|
| POST   | /api/usuarios/password.php   | Cambiar contraseña    | ✓    |

---

### 📋 Roles del Sistema

| Rol          | Descripción                          |
|--------------|--------------------------------------|
| admin        | Acceso total al sistema              |
| almacen      | Compras, recepción, ajuste de stock  |
| vendedor     | Ventas y consulta de inventario      |
| solo_lectura | Solo puede ver reportes              |

---

### 🇻🇪 Contexto Venezuela

- Zona horaria configurada: **America/Caracas**
- IVA por defecto: **16%**
- Monedas: **USD + VES (Bolívares)**

---

**Fresil C.A.** · Mecánica Ligera / Silenciadores · Caracas
